﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;

public partial class ReportInitialScreeningNationalSummary : System.Web.UI.Page
{
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if(AccessAllowed())
        {
            if (!Page.IsPostBack)
            {
                Session["ReportYear"] = "09";
                Session["ReportMonth"] = "August";
            }

            ReportViewer1.Visible = true;
            SetReportParameters();
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    private void SetReportParameters()
    {

        ReportViewer1.Reset();

        ReportViewer1.ServerReport.ReportPath = "ReportScreenNationalSummary";

        //var config = RegistriesConfigurations.GetConfig();

        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
        {
            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
            //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
        }

        ReportParameter paramMonth = new ReportParameter("Month", (string)Session["ReportMonth"]);
        ReportParameter paramYear = new ReportParameter("Year", (string)Session["ReportYear"]);
        ReportParameter paramUsername = new ReportParameter("Username", _currentUser.FullName);

        //ReportViewer1.LocalReport.SetParameters(new ReportParameter[] { paramMonth, paramYear });
        ReportViewer1.ServerReport.SetParameters(new ReportParameter[] { paramMonth, paramYear, paramUsername });

        ReportViewer1.ProcessingMode = ProcessingMode.Remote;
        ReportViewer1.ServerReport.Refresh();

    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return _currentUser.IsInRole(16);
    }
}
